local t = Def.ActorFrame {};
t[#t+1] = LoadActor("_P1chartelements") .. { 
	InitCommand=function(self) self:horizalign(center):addy(-15):zoom(0.6) end;
};

t[#t+1] = LoadFont("_pixellari 32px") .. { -- Tap count
		  InitCommand=cmd(horizalign,right;zoom,0.75;x,110;addy,-43);
		  OnCommand=cmd(queuecommand,"Transition";);
          CurrentStepsP1ChangedMessageCommand=cmd(finishtweening;queuecommand,"Set";); 
		  CurrentSongChangedMessageCommand=cmd(playcommand,"Set");
		  TransitionCommand=cmd(diffusealpha,0;addy,-3;smooth,0.2;diffusealpha,1;addy,3;);
		  PlayerJoinedMessageCommand=cmd(queuecommand,"Set";diffusealpha,0;smooth,0.3;diffusealpha,1;);
          ChangedLanguageDisplayMessageCommand=cmd(queuecommand,"Set"); 
          SetCommand=function(self)
			stepsP1 = GAMESTATE:GetCurrentSteps(PLAYER_1)
			local song = GAMESTATE:GetCurrentSong();
			if song then 
				if stepsP1 ~= nil then
					local Getp1Radar = GAMESTATE:GetCurrentSteps(PLAYER_1):GetRadarValues(PLAYER_1);
					local P1Taps = Getp1Radar:GetValue('RadarCategory_TapsAndHolds')+Getp1Radar:GetValue('RadarCategory_Jumps')+Getp1Radar:GetValue('RadarCategory_Hands');
					self:settext(P1Taps);
				else
					self:settext("0")
				end
			else
				self:settext("-")
			end
         end
};

t[#t+1] = LoadFont("_pixellari 32px") .. { -- Hold count
		  InitCommand=cmd(horizalign,right;zoom,0.75;addx,110;addy,-25;);
		  OnCommand=cmd(queuecommand,"Transition";);
          CurrentStepsP1ChangedMessageCommand=cmd(finishtweening;queuecommand,"Set";); 
		  CurrentSongChangedMessageCommand=cmd(playcommand,"Set");
		  TransitionCommand=cmd(diffusealpha,0;addy,-3;smooth,0.2;diffusealpha,1;addy,3;);
		  PlayerJoinedMessageCommand=cmd(queuecommand,"Set";diffusealpha,0;smooth,0.3;diffusealpha,1;);
          ChangedLanguageDisplayMessageCommand=cmd(queuecommand,"Set"); 
          SetCommand=function(self)
			stepsP1 = GAMESTATE:GetCurrentSteps(PLAYER_1)
			local song = GAMESTATE:GetCurrentSong();
			if song then 
				if stepsP1 ~= nil then
					local Getp1Radar = GAMESTATE:GetCurrentSteps(PLAYER_1):GetRadarValues(PLAYER_1);
					local P1Holds = Getp1Radar:GetValue('RadarCategory_Holds');
					self:settext(P1Holds);
				else
					self:settext("0")
				end
			else
				self:settext("-")
			end
         end
};

t[#t+1] = LoadFont("_pixellari 32px") .. { -- Jump count
		  InitCommand=cmd(horizalign,right;zoom,0.75;addx,110;addy,-7;);
		  OnCommand=cmd(queuecommand,"Transition";);
          CurrentStepsP1ChangedMessageCommand=cmd(finishtweening;queuecommand,"Set";); 
		  CurrentSongChangedMessageCommand=cmd(playcommand,"Set");
		  TransitionCommand=cmd(diffusealpha,0;addy,-3;smooth,0.2;diffusealpha,1;addy,3;);
		  PlayerJoinedMessageCommand=cmd(queuecommand,"Set";diffusealpha,0;smooth,0.3;diffusealpha,1;);
          ChangedLanguageDisplayMessageCommand=cmd(queuecommand,"Set"); 
          SetCommand=function(self)
			stepsP1 = GAMESTATE:GetCurrentSteps(PLAYER_1)
			local song = GAMESTATE:GetCurrentSong();
			if song then 
				if stepsP1 ~= nil then
					local Getp1Radar = GAMESTATE:GetCurrentSteps(PLAYER_1):GetRadarValues(PLAYER_1);
					local P1Jumps = Getp1Radar:GetValue('RadarCategory_Jumps');
					self:settext(P1Jumps);
				else
					self:settext("0")
				end
			else
				self:settext("-")
			end
         end
};

t[#t+1] = LoadFont("_pixellari 32px") .. { -- Mine count
		  InitCommand=cmd(horizalign,right;zoom,0.75;addx,110;addy,11);
		  OnCommand=cmd(queuecommand,"Transition";);
          CurrentStepsP1ChangedMessageCommand=cmd(finishtweening;queuecommand,"Set";); 
		  CurrentSongChangedMessageCommand=cmd(playcommand,"Set");
		  TransitionCommand=cmd(diffusealpha,0;addy,-3;smooth,0.2;diffusealpha,1;addy,3;);
		  PlayerJoinedMessageCommand=cmd(queuecommand,"Set";diffusealpha,0;smooth,0.3;diffusealpha,1;);
          ChangedLanguageDisplayMessageCommand=cmd(queuecommand,"Set"); 
          SetCommand=function(self)
			stepsP1 = GAMESTATE:GetCurrentSteps(PLAYER_1)
			local song = GAMESTATE:GetCurrentSong();
			if song then 
				if stepsP1 ~= nil then
					local Getp1Radar = GAMESTATE:GetCurrentSteps(PLAYER_1):GetRadarValues(PLAYER_1);
					local P1Mines = Getp1Radar:GetValue('RadarCategory_Mines');
					self:settext(P1Mines);
				else
					self:settext("0")
				end
			else
				self:settext("-")
			end
         end
};

t[#t+1] = LoadFont("_pixellari 32px") .. { -- Score
		  InitCommand=cmd(x,40;y,40;diffuse,ColorLightTone( PlayerColor(PLAYER_1) );strokecolor,(color("#000000")););
		  OnCommand=cmd(horizalign,center;zoom,0.8);
		  OffCommand=cmd(decelerate,0.2;zoomy,0);
		  CurrentSongChangedMessageCommand=cmd(finishtweening;playcommand,"Set");
		  CurrentCourseChangedMessageCommand=cmd(finishtweening;playcommand,"Set");
		  CurrentStepsP1ChangedMessageCommand=cmd(playcommand,"Set";playcommand,"Transition");
		  TransitionCommand=cmd(finishtweening;playcommand,"Set");
		  PlayerJoinedMessageCommand=cmd(queuecommand,"Set";diffusealpha,0;smooth,0.3;diffusealpha,1;);
          	  ChangedLanguageDisplayMessageCommand=cmd(queuecommand,"Set");
          	  SetCommand=function(self)
      		 local steps = GAMESTATE:GetCurrentSteps(PLAYER_1);
		 local song = GAMESTATE:GetCurrentSong();
			if song then
				if steps ~= nil then
					local score = PROFILEMAN:GetProfile(PLAYER_1):GetHighScoreList(song,steps):GetHighScores();
					local getscore = score[1]	
						if getscore then
							local P1score = getscore:GetScore();				
							self:smooth(0.2);
							self:diffusealpha(0);
							self:settextf(" %s ", round(P1score/100));
							self:playcommand("Refresh");
							self:stoptweening():diffusealpha(0):smooth(0.2):diffusealpha(1);
						else
							self:smooth(0.2):diffusealpha(0);
							self:settext("UNPLAYED");
							self:visible(GAMESTATE:IsHumanPlayer(PLAYER_1));
							self:stoptweening():diffusealpha(0):smooth(0.2):diffusealpha(1);							
						end
				else
					self:smooth(0.2):diffusealpha(0);				
					self:settext("");
					self:playcommand("Refresh");
					self:visible(GAMESTATE:IsHumanPlayer(PLAYER_1));
					self:stoptweening():diffusealpha(0):smooth(0.2):diffusealpha(1);
                end
			else
				self:settext("---");
			end
		end	
};

return t